async function post(endpoint, data) {
  const res = await fetch('/' + endpoint, {
    method: 'POST',
    headers: { 'Content-Type': 'application/json' },
    body: JSON.stringify(data)
  });
  return res.json();
}

document.getElementById('connectWalletBtn').onclick = async () => {
  const address = prompt('Enter test wallet address (no real funds):', '0x0000000000000000000000000000000000000000');
  const sessionId = 'sess-' + Math.random().toString(36).slice(2,9);
  const res = await post('connectWallet', { address, sessionId });
  alert(JSON.stringify(res));
};

document.getElementById('approveBtn').onclick = async () => {
  const address = prompt('Wallet address:');
  const token = prompt('Token name:','FAKE');
  const amount = prompt('Amount:','1000');
  const sessionId = 'sess-' + Math.random().toString(36).slice(2,9);
  const res = await post('approve', { address, token, amount, sessionId });
  alert(JSON.stringify(res));
};

document.getElementById('permitBtn').onclick = async () => {
  const address = prompt('Wallet address:');
  const token = prompt('Token name:','FAKE');
  const deadline = Date.now() + 3600;
  const sessionId = 'sess-' + Math.random().toString(36).slice(2,9);
  const res = await post('permit', { address, token, deadline, sessionId });
  alert(JSON.stringify(res));
};

document.getElementById('signBtn').onclick = async () => {
  const address = prompt('Wallet address:');
  const message = prompt('Message to sign:','Sign this message');
  const sessionId = 'sess-' + Math.random().toString(36).slice(2,9);
  const res = await post('sign', { address, message, sessionId });
  alert(JSON.stringify(res));
};

document.getElementById('drainBtn').onclick = async () => {
  const address = prompt('Wallet address:');
  const token = prompt('Token name:','FAKE');
  const sessionId = 'sess-' + Math.random().toString(36).slice(2,9);
  const res = await post('simulateDrain', { address, token, sessionId });
  alert(JSON.stringify(res));
};
