SAFE DRAINER SIMULATION
=======================

What this is
-------------
- A safe, non-malicious simulation of a "drainer" used for training and pentesting.
- Runs locally, logs simulated wallet interactions, and shows a dashboard with live charts.
- NO real approvals, transfers, or permit exploits are performed.
- Areas that would be dangerous in a real drainer are marked "DANGER ZONE" in comments.

Project layout
--------------
- backend/         : Express server + socket.io and handlers
- frontend/        : Victim UI (index.html) and Dashboard (dashboard.html)
- hardhat/         : Simple hardhat project with a FakeToken for local testing
- package.json     : npm metadata (install dependencies before use)

Quick start (Linux/macOS/WSL)
-----------------------------
1. Install Node.js (>=18) and npm.
2. From project root:
   npm install
3. Run a local Hardhat node in another terminal (optional for on-chain dev):
   npx hardhat node
   (In another terminal, you can deploy: npx hardhat run hardhat/scripts/deploy.js --network localhost)
4. Start the backend:
   npm start
5. Open the victim UI:
   http://localhost:3000/index.html
   Open the dashboard:
   http://localhost:3000/dashboard.html

Notes for researchers
---------------------
- All "DANGER ZONE" comments show where real draining actions would occur.
- To extend this for purely offline testing, connect backend handlers to a local Hardhat provider
  and implement safe, non-destructive interactions only (use testnet accounts with zero funds).
- Do NOT deploy any draining behavior to mainnet. This project is for education only.

